"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostMetrics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_tab_switcher = require("../../../hooks/use_tab_switcher");
var _charts = require("../../../charts");
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostMetrics = props => {
  const {
    showTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const onClick = metric => {
    showTab(_types.ContentTabIds.METRICS, {
      scrollTo: metric
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_charts.HostCharts, (0, _extends2.default)({}, props, {
    metric: "cpu",
    onShowAll: onClick,
    overview: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_charts.HostCharts, (0, _extends2.default)({}, props, {
    metric: "memory",
    onShowAll: onClick,
    overview: true
  })), /*#__PURE__*/_react.default.createElement(_charts.HostCharts, (0, _extends2.default)({}, props, {
    metric: "network",
    onShowAll: onClick,
    overview: true
  }))), /*#__PURE__*/_react.default.createElement(_charts.HostCharts, (0, _extends2.default)({}, props, {
    metric: "disk",
    onShowAll: onClick,
    overview: true
  })), /*#__PURE__*/_react.default.createElement(_charts.KubernetesNodeCharts, (0, _extends2.default)({}, props, {
    onShowAll: onClick,
    overview: true
  })));
};
exports.HostMetrics = HostMetrics;