"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KPIGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _build = require("../../../../../utils/filters/build");
var _host_kpi_charts = require("../../../components/kpis/host_kpi_charts");
var _container_kpi_charts = require("../../../components/kpis/container_kpi_charts");
var _use_reload_request_time = require("../../../../../hooks/use_reload_request_time");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KPIGrid = ({
  assetId,
  assetType,
  dataView,
  dateRange
}) => {
  const {
    reloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const filters = (0, _react.useMemo)(() => {
    return [(0, _build.buildCombinedAssetFilter)({
      field: (0, _common.findInventoryFields)(assetType).id,
      values: [assetId],
      dataView
    })];
  }, [dataView, assetId, assetType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    "data-test-subj": "infraAssetDetailsKPIGrid"
  }, assetType === 'host' ? /*#__PURE__*/_react.default.createElement(_host_kpi_charts.HostKpiCharts, {
    dataView: dataView,
    filters: filters,
    dateRange: dateRange,
    lastReloadRequestTime: reloadRequestTime
  }) : /*#__PURE__*/_react.default.createElement(_container_kpi_charts.ContainerKpiCharts, {
    dataView: dataView,
    filters: filters,
    dateRange: dateRange,
    lastReloadRequestTime: reloadRequestTime
  }));
};
exports.KPIGrid = KPIGrid;