"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToApmServices = void 0;
var _react = _interopRequireDefault(require("react"));
var _querystring = require("querystring");
var _rison = require("@kbn/rison");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkToApmServices = ({
  assetId,
  apmField
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = services;
  const queryString = new URLSearchParams((0, _rison.encode)((0, _querystring.stringify)({
    kuery: `${apmField}:"${assetId}"`
  })));
  const linkToApmServices = http.basePath.prepend(`/app/apm/services?${queryString}`);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.apmServicesLink.ariaLabel', {
      defaultMessage: 'Show all APM services'
    }),
    "data-test-subj": "infraAssetDetailsViewAPMShowAllServicesButton",
    size: "xs",
    flush: "both",
    href: linkToApmServices,
    iconSide: "right",
    iconType: "sortRight"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.flyout.viewApmServicesLinkLabel",
    defaultMessage: "Show all"
  }));
};
exports.LinkToApmServices = LinkToApmServices;