"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageTitleWithPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _popover = require("../tabs/common/popover");
var _use_metadata_state = require("../hooks/use_metadata_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PageTitleWithPopover = ({
  name
}) => {
  const {
    metadata,
    loading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, name), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : !(metadata !== null && metadata !== void 0 && metadata.hasSystemIntegration) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    icon: "question",
    "data-test-subj": "assetDetailsTitleHasSystemMetricsPopover",
    "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.title.tooltip.ariaLabel', {
      defaultMessage: 'Host detected by APM'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.title.tooltip.apmHostMessage",
    defaultMessage: "This host has been detected by {apm}",
    values: {
      apm: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "assetDetailsTitleTooltipApmDocumentationLink",
        href: " https://www.elastic.co/guide/en/observability/current/apm.html",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.title.tooltip.apmHostMessage.apmDocumentationLink",
        defaultMessage: "APM"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "assetDetailsTitleHasSystemMetricsLearnMoreLink",
    href: _constants.APM_HOST_TROUBLESHOOTING_LINK,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.title.tooltip.learnMoreLink",
    defaultMessage: "Learn more"
  })))))));
};
exports.PageTitleWithPopover = PageTitleWithPopover;