"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMetricsExplorerData = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformMetricsExplorerData = (params, data) => {
  const {
    criteria
  } = params;
  const firstSeries = (0, _lodash.first)(data === null || data === void 0 ? void 0 : data.series);
  if (criteria && firstSeries) {
    const series = firstSeries.rows.reduce((acc, row) => {
      const {
        timestamp
      } = row;
      criteria.forEach((item, index) => {
        if (!acc[index]) {
          acc[index] = [];
        }
        const value = row[`metric_${index}`] || 0;
        acc[index].push({
          timestamp,
          value
        });
      });
      return acc;
    }, []);
    return {
      id: firstSeries.id,
      series
    };
  }
};
exports.transformMetricsExplorerData = transformMetricsExplorerData;