"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsExplorerChartData = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _react = require("react");
var _use_metrics_explorer_data = require("../../../pages/metrics/metrics_explorer/hooks/use_metrics_explorer_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TIME_RANGE = {};
const useMetricsExplorerChartData = ({
  expression,
  filterQuery,
  groupBy,
  groupInstance,
  timeRange = DEFAULT_TIME_RANGE
}) => {
  const {
    timeSize,
    timeUnit
  } = expression || {
    timeSize: 1,
    timeUnit: 'm'
  };
  const options = (0, _react.useMemo)(() => {
    var _expression$customMet, _expression$customMet2;
    return {
      limit: 1,
      forceInterval: true,
      dropLastBucket: false,
      groupBy,
      groupInstance,
      filterQuery,
      metrics: [expression.aggType === 'custom' ? {
        aggregation: 'custom',
        custom_metrics: (_expression$customMet = expression === null || expression === void 0 ? void 0 : (_expression$customMet2 = expression.customMetrics) === null || _expression$customMet2 === void 0 ? void 0 : _expression$customMet2.map(mapMetricThresholdMetricToMetricsExplorerMetric)) !== null && _expression$customMet !== void 0 ? _expression$customMet : [],
        equation: expression.equation
      } : {
        field: expression.metric,
        aggregation: expression.aggType
      }],
      aggregation: expression.aggType || 'avg'
    };
  }, [expression.aggType, expression.equation, expression.metric, expression.customMetrics, filterQuery, groupBy, groupInstance]);
  const timestamps = (0, _react.useMemo)(() => {
    var _timeRange$from, _timeRange$to;
    const from = (_timeRange$from = timeRange.from) !== null && _timeRange$from !== void 0 ? _timeRange$from : `now-${(timeSize || 1) * 20}${timeUnit}`;
    const to = (_timeRange$to = timeRange.to) !== null && _timeRange$to !== void 0 ? _timeRange$to : 'now';
    const fromTimestamp = _datemath.default.parse(from).valueOf();
    const toTimestamp = _datemath.default.parse(to, {
      roundUp: true
    }).valueOf();
    return {
      interval: `>=${timeSize || 1}${timeUnit}`,
      fromTimestamp,
      toTimestamp
    };
  }, [timeRange, timeSize, timeUnit]);
  return (0, _use_metrics_explorer_data.useMetricsExplorerData)({
    options,
    timestamps
  });
};
exports.useMetricsExplorerChartData = useMetricsExplorerChartData;
const mapMetricThresholdMetricToMetricsExplorerMetric = metric => {
  if (metric.aggType === 'count') {
    return {
      name: metric.name,
      aggregation: 'count',
      filter: metric.filter
    };
  }
  return {
    name: metric.name,
    aggregation: metric.aggType,
    field: metric.field
  };
};