"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleFormatter = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRuleFormatter = logsLocator => ({
  fields
}) => {
  var _fields$ALERT_REASON;
  const reason = (_fields$ALERT_REASON = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON !== void 0 ? _fields$ALERT_REASON : '';
  const alertStartDate = fields[_ruleDataUtils.ALERT_START];
  const time = alertStartDate != null ? new Date(alertStartDate).valueOf() : undefined;
  const url = logsLocator.getRedirectUrl({
    time
  });

  // the alerts UI already prepends the url to the baseUrl so we need to remove it here
  const link = removeBaseUrl(url);
  return {
    reason,
    link
  };
};
exports.createRuleFormatter = createRuleFormatter;
const removeBaseUrl = url => {
  const substring = '/app/';
  const substringIndex = url.indexOf(substring);
  return url.substring(substringIndex);
};