"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeTypeExpression = exports.ClosablePopoverTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeTypeExpression = ({
  value,
  options,
  onChange,
  popupPosition
}) => {
  const [aggTypePopoverOpen, setAggTypePopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "nodeTypeExpression",
      description: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.for.descriptionLabel', {
        defaultMessage: 'For'
      }),
      value: options[value].text,
      isActive: aggTypePopoverOpen,
      onClick: () => {
        setAggTypePopoverOpen(true);
      }
    }),
    isOpen: aggTypePopoverOpen,
    closePopover: () => {
      setAggTypePopoverOpen(false);
    },
    ownFocus: true,
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft'
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(ClosablePopoverTitle, {
    onClose: () => setAggTypePopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.expression.for.popoverTitle",
    defaultMessage: "Node Type"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "forExpressionSelect",
    value: value,
    fullWidth: true,
    onChange: e => {
      onChange(e.target.value);
      setAggTypePopoverOpen(false);
    },
    options: Object.values(options).map(o => o)
  })));
};
exports.NodeTypeExpression = NodeTypeExpression;
const ClosablePopoverTitle = ({
  children,
  onClose
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraClosablePopoverTitleButton",
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel', {
      defaultMessage: 'Close'
    }),
    onClick: () => onClose()
  }))));
};
exports.ClosablePopoverTitle = ClosablePopoverTitle;