"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validationIndicesResponsePayloadRT = exports.validationIndicesRequestPayloadRT = exports.validationIndicesFieldSpecificationRT = exports.validationIndicesErrorRT = exports.LOG_ANALYSIS_VALIDATE_INDICES_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _es_request = require("../../../shared/es_request");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_ANALYSIS_VALIDATE_INDICES_PATH = exports.LOG_ANALYSIS_VALIDATE_INDICES_PATH = '/api/infra/log_analysis/validation/log_entry_rate_indices';

/**
 * Request types
 */
const validationIndicesFieldSpecificationRT = exports.validationIndicesFieldSpecificationRT = rt.type({
  name: rt.string,
  validTypes: rt.array(rt.string)
});
const validationIndicesRequestPayloadRT = exports.validationIndicesRequestPayloadRT = rt.type({
  data: rt.type({
    fields: rt.array(validationIndicesFieldSpecificationRT),
    indices: rt.array(rt.string),
    runtimeMappings: rt.record(rt.string, _es_request.mappingRuntimeFieldRT)
  })
});
/**
 * Response types
 * */
const validationIndicesErrorRT = exports.validationIndicesErrorRT = rt.union([rt.type({
  error: rt.literal('INDEX_NOT_FOUND'),
  index: rt.string
}), rt.type({
  error: rt.literal('FIELD_NOT_FOUND'),
  index: rt.string,
  field: rt.string
}), rt.type({
  error: rt.literal('FIELD_NOT_VALID'),
  index: rt.string,
  field: rt.string
})]);
const validationIndicesResponsePayloadRT = exports.validationIndicesResponsePayloadRT = rt.type({
  data: rt.type({
    errors: rt.array(validationIndicesErrorRT)
  })
});