"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withExecuteToolSpan = withExecuteToolSpan;
var _types = require("util/types");
var _std = require("@kbn/std");
var _with_inference_span = require("./with_inference_span");
var _types2 = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Wrapper around {@link withInferenceSpan} that sets the right attributes for a execute_tool operation span.
 * @param options
 * @param cb
 */
function withExecuteToolSpan(options, cb) {
  const {
    name,
    description,
    toolCallId,
    input
  } = typeof options === 'string' ? {
    name: options,
    description: undefined,
    toolCallId: undefined,
    input: undefined
  } : options;
  return (0, _with_inference_span.withInferenceSpan)({
    name: `execute_tool ${name}`,
    [_types2.GenAISemanticConventions.GenAIToolName]: name,
    [_types2.GenAISemanticConventions.GenAIOperationName]: 'execute_tool',
    [_types2.GenAISemanticConventions.GenAIToolCallId]: toolCallId,
    [_types2.ElasticGenAIAttributes.InferenceSpanKind]: 'TOOL',
    [_types2.ElasticGenAIAttributes.ToolDescription]: description,
    [_types2.ElasticGenAIAttributes.ToolParameters]: (0, _std.safeJsonStringify)(input)
  }, span => {
    if (!span) {
      return cb();
    }
    const res = cb(span);
    if ((0, _types.isPromise)(res)) {
      res.then(value => {
        const stringified = (0, _std.safeJsonStringify)(value);
        if (stringified) {
          span.setAttribute('output.value', stringified);
        }
      },
      // if the promise fails, we catch it and noop
      () => {});
      return res;
    }
    return res;
  });
}