"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRestClient = createRestClient;
var _bind_client = require("../inference_client/bind_client");
var _inference_client = require("./inference_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createRestClient(options) {
  const {
    fetch,
    signal
  } = options;
  const client = (0, _inference_client.createInferenceRestClient)({
    fetch,
    signal
  });
  if ('bindTo' in options) {
    return (0, _bind_client.bindClient)(client, options.bindTo);
  } else {
    return client;
  }
}