"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexMgmtServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _plugin = require("../common/constants/plugin");
var _routes = require("./routes");
var _services = require("./services");
var _shared_imports = require("./shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexMgmtServerPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "apiRoutes", void 0);
    (0, _defineProperty2.default)(this, "indexDataEnricher", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.apiRoutes = new _routes.ApiRoutes();
    this.indexDataEnricher = new _services.IndexDataEnricher();
    this.config = initContext.config.get();
  }
  setup({
    http,
    getStartServices
  }, {
    features,
    security
  }) {
    var _this$config$enableIn, _this$config$enableSi, _this$config$enablePr;
    features.registerElasticsearchFeature({
      id: _plugin.PLUGIN.id,
      privileges: [{
        requiredClusterPrivileges: ['monitor_enrich'],
        ui: ['monitorEnrich']
      }, {
        requiredClusterPrivileges: ['manage_enrich'],
        ui: ['manageEnrich']
      }, {
        requiredClusterPrivileges: ['manage_index_templates'],
        ui: ['manageIndexTemplates']
      }, {
        // manage_index_templates is also required, but we will disable specific parts of the
        // UI if this privilege is missing.
        requiredClusterPrivileges: ['monitor'],
        ui: ['monitor']
      }]
    });
    this.apiRoutes.setup({
      router: http.createRouter(),
      config: {
        isSecurityEnabled: () => security !== undefined && security.license.isEnabled(),
        isLegacyTemplatesEnabled: this.config.enableLegacyTemplates,
        isIndexStatsEnabled: (_this$config$enableIn = this.config.enableIndexStats) !== null && _this$config$enableIn !== void 0 ? _this$config$enableIn : true,
        isSizeAndDocCountEnabled: (_this$config$enableSi = this.config.enableSizeAndDocCount) !== null && _this$config$enableSi !== void 0 ? _this$config$enableSi : false,
        enableProjectLevelRetentionChecks: (_this$config$enablePr = this.config.enableProjectLevelRetentionChecks) !== null && _this$config$enablePr !== void 0 ? _this$config$enablePr : false,
        isDataStreamStatsEnabled: this.config.enableDataStreamStats,
        enableMappingsSourceFieldSection: this.config.enableMappingsSourceFieldSection,
        enableTogglingDataRetention: this.config.enableTogglingDataRetention
      },
      indexDataEnricher: this.indexDataEnricher,
      lib: {
        handleEsError: _shared_imports.handleEsError
      }
    });
    return {
      indexDataEnricher: {
        add: this.indexDataEnricher.add.bind(this.indexDataEnricher)
      }
    };
  }
  start() {}
  stop() {}
}
exports.IndexMgmtServerPlugin = IndexMgmtServerPlugin;