"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.breadcrumbService = exports.IndexManagementBreadcrumb = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let IndexManagementBreadcrumb = exports.IndexManagementBreadcrumb = /*#__PURE__*/function (IndexManagementBreadcrumb) {
  IndexManagementBreadcrumb["home"] = "home";
  IndexManagementBreadcrumb["indices"] = "indices";
  IndexManagementBreadcrumb["indexDetails"] = "indexDetails";
  IndexManagementBreadcrumb["dataStreams"] = "dataStreams";
  IndexManagementBreadcrumb["templates"] = "templates";
  IndexManagementBreadcrumb["templateCreate"] = "templateCreate";
  IndexManagementBreadcrumb["templateEdit"] = "templateEdit";
  IndexManagementBreadcrumb["templateClone"] = "templateClone";
  IndexManagementBreadcrumb["componentTemplates"] = "componentTemplates";
  IndexManagementBreadcrumb["componentTemplateCreate"] = "componentTemplateCreate";
  IndexManagementBreadcrumb["componentTemplateEdit"] = "componentTemplateEdit";
  IndexManagementBreadcrumb["componentTemplateClone"] = "componentTemplateClone";
  IndexManagementBreadcrumb["enrichPolicies"] = "enrichPolicies";
  IndexManagementBreadcrumb["enrichPoliciesCreate"] = "enrichPoliciesCreate";
  return IndexManagementBreadcrumb;
}({});
class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {
      home: []
    });
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;
    this.breadcrumbs.home = [{
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.homeLabel', {
        defaultMessage: 'Index Management'
      }),
      href: `/`
    }];
    this.breadcrumbs.indices = [...this.breadcrumbs.home, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.indicesLabel', {
        defaultMessage: 'Indices'
      }),
      href: `/indices`
    }];
    this.breadcrumbs.indexDetails = [...this.breadcrumbs.indices, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.indexDetailsLabel', {
        defaultMessage: 'Index details'
      })
    }];
    this.breadcrumbs.templates = [...this.breadcrumbs.home, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.templatesLabel', {
        defaultMessage: 'Templates'
      }),
      href: `/templates`
    }];
    this.breadcrumbs.templateCreate = [...this.breadcrumbs.templates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.createTemplateLabel', {
        defaultMessage: 'Create template'
      })
    }];
    this.breadcrumbs.templateEdit = [...this.breadcrumbs.templates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.editTemplateLabel', {
        defaultMessage: 'Edit template'
      })
    }];
    this.breadcrumbs.templateClone = [...this.breadcrumbs.templates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.cloneTemplateLabel', {
        defaultMessage: 'Clone template'
      })
    }];
    this.breadcrumbs.dataStreams = [...this.breadcrumbs.home, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.dataStreamsLabel', {
        defaultMessage: 'Data streams'
      }),
      href: `/data_streams`
    }];
    this.breadcrumbs.componentTemplates = [...this.breadcrumbs.home, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.componentTemplatesLabel', {
        defaultMessage: 'Component templates'
      }),
      href: `/component_templates`
    }];
    this.breadcrumbs.componentTemplateCreate = [...this.breadcrumbs.componentTemplates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.createComponentTemplateLabel', {
        defaultMessage: 'Create component templates'
      })
    }];
    this.breadcrumbs.componentTemplateEdit = [...this.breadcrumbs.componentTemplates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.componentTemplate.breadcrumb.editComponentTemplateLabel', {
        defaultMessage: 'Edit component template'
      })
    }];
    this.breadcrumbs.componentTemplateClone = [...this.breadcrumbs.componentTemplates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.componentTemplate.breadcrumb.cloneComponentTemplateLabel', {
        defaultMessage: 'Clone component template'
      })
    }];
    this.breadcrumbs.enrichPolicies = [...this.breadcrumbs.home, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.enrichPolicyLabel', {
        defaultMessage: 'Enrich policies'
      }),
      href: `/enrich_policies`
    }];
    this.breadcrumbs.enrichPoliciesCreate = [...this.breadcrumbs.enrichPolicies, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.enrichPolicyCreateLabel', {
        defaultMessage: 'Create enrich policy'
      }),
      href: `/enrich_policies/create`
    }];
  }
  setBreadcrumbs(type, additionalBreadcrumb) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error(`BreadcrumbService#setup() must be called first!`);
    }
    const newBreadcrumbs = this.breadcrumbs[type] ? [...this.breadcrumbs[type]] : [...this.breadcrumbs.home];
    if (additionalBreadcrumb) {
      newBreadcrumbs.push(additionalBreadcrumb);
    }

    // Pop off last breadcrumb
    const lastBreadcrumb = newBreadcrumbs.pop();

    // Put last breadcrumb back without href
    newBreadcrumbs.push({
      ...lastBreadcrumb,
      href: undefined
    });
    this.setBreadcrumbsHandler(newBreadcrumbs);
  }
}
const breadcrumbService = exports.breadcrumbService = new BreadcrumbService();