"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editDataRetentionFormSchema = void 0;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _i18n = require("@kbn/i18n");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _validations = require("./validations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const editDataRetentionFormSchema = exports.editDataRetentionFormSchema = {
  dataRetention: {
    type: _hook_form_lib.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.dataRetentionField', {
      defaultMessage: 'Data retention period'
    }),
    formatters: [_helpers.fieldFormatters.toInt],
    validations: [{
      validator: _helpers.fieldValidators.isInteger({
        message: _i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.dataRetentionFieldIntegerError', {
          defaultMessage: 'Only integers are allowed.'
        })
      })
    }, {
      validator: ({
        value,
        formData,
        customData
      }) => {
        // We only need to validate the data retention field if infiniteRetentionPeriod is set to false and dataRetentionEnabled is set to true
        if (formData.dataRetentionEnabled !== false && !formData.infiniteRetentionPeriod) {
          // If project level data retention is enabled, we need to enforce the global max retention
          const {
            globalMaxRetention,
            enableProjectLevelRetentionChecks
          } = customData.value;
          if (enableProjectLevelRetentionChecks) {
            return (0, _validations.isBiggerThanGlobalMaxRetention)(value, formData.timeUnit, globalMaxRetention);
          }
        }
      }
    }, {
      validator: args => {
        // We only need to validate the data retention field if infiniteRetentionPeriod is set to false and dataRetentionEnabled is set to true
        if (args.formData.dataRetentionEnabled !== false && !args.formData.infiniteRetentionPeriod) {
          return _helpers.fieldValidators.emptyField(_i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.dataRetentionFieldRequiredError', {
            defaultMessage: 'A data retention value is required.'
          }))(args);
        }
      }
    }, {
      validator: args => {
        // We only need to validate the data retention field if infiniteRetentionPeriod is set to false and dataRetentionEnabled is set to true
        if (args.formData.dataRetentionEnabled !== false && !args.formData.infiniteRetentionPeriod) {
          return _helpers.fieldValidators.numberGreaterThanField({
            than: 0,
            allowEquality: false,
            message: _i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.dataRetentionFieldNonNegativeError', {
              defaultMessage: `A positive value is required.`
            })
          })(args);
        }
      }
    }]
  },
  timeUnit: {
    type: _hook_form_lib.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.timeUnitField', {
      defaultMessage: 'Time unit'
    })
  },
  infiniteRetentionPeriod: {
    type: _hook_form_lib.FIELD_TYPES.TOGGLE,
    defaultValue: false
  },
  dataRetentionEnabled: {
    type: _hook_form_lib.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    label: _i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.dataRetentionEnabledField', {
      defaultMessage: 'Enable data retention'
    })
  }
};