"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureFailureStoreModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _schema = require("./schema");
var _shared_imports = require("../../../../../shared_imports");
var _app_context = require("../../../../app_context");
var _api = require("../../../../services/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigureFailureStoreModal = ({
  dataStreams,
  onClose
}) => {
  var _dataStream$failureSt;
  // We will support multiple data streams in the future, but for now we only support one.
  const dataStream = dataStreams[0];
  const {
    services: {
      notificationService
    }
  } = (0, _app_context.useAppContext)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      dsFailureStore: (_dataStream$failureSt = dataStream === null || dataStream === void 0 ? void 0 : dataStream.failureStoreEnabled) !== null && _dataStream$failureSt !== void 0 ? _dataStream$failureSt : false
    },
    schema: _schema.configureFailureStoreFormSchema,
    id: 'configureFailureStoreForm'
  });
  const isDirty = (0, _shared_imports.useFormIsModified)({
    form
  });
  const formHasErrors = form.getErrors().length > 0;
  const disableSubmit = formHasErrors || !isDirty || form.isValid === false;
  const onSubmitForm = async () => {
    const {
      isValid,
      data
    } = await form.submit();
    if (!isValid) {
      return;
    }
    return (0, _api.updateDSFailureStore)([dataStream.name], data).then(({
      data: responseData,
      error
    }) => {
      if (responseData) {
        if (responseData.warning) {
          notificationService.showWarningToast(responseData.warning);
          return onClose({
            hasUpdatedFailureStore: true
          });
        }
        const successMessage = _i18n.i18n.translate('xpack.idxMgmt.dataStreams.configureFailureStoreModal.successFailureStoreNotification', {
          defaultMessage: 'Failure store {disabledFailureStore, plural, one { disabled } other { enabled } }',
          values: {
            disabledFailureStore: !data.dsFailureStore ? 1 : 0
          }
        });
        notificationService.showSuccessToast(successMessage);
        return onClose({
          hasUpdatedFailureStore: true
        });
      }
      if (error) {
        const errorMessage = _i18n.i18n.translate('xpack.idxMgmt.dataStreams.configureFailureStoreModal.errorFailureStoreNotification', {
          defaultMessage: "Error configuring failure store: ''{error}''",
          values: {
            error: error.message
          }
        });
        notificationService.showDangerToast(errorMessage);
      }
      onClose();
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => onClose(),
    "data-test-subj": "configureFailureStoreModal",
    css: {
      width: 650
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "configureFailureStoreForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.configureFailureStoreModal.modalTitleText",
    defaultMessage: "Configure failure store"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.configureFailureStoreModal.modalDescriptionText",
    defaultMessage: "A failure store is a secondary index within a data stream, used to store failed documents."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "dsFailureStore",
    component: _shared_imports.ToggleField,
    "data-test-subj": "enableDataStreamFailureStoreToggle",
    euiFieldProps: {
      label: _i18n.i18n.translate('xpack.idxMgmt.dataStreams.configureFailureStoreModal.infiniteRetentionPeriodField', {
        defaultMessage: 'Enable data stream failure store'
      })
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelButton",
    onClick: () => onClose()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.configureFailureStoreModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    isLoading: false,
    disabled: disableSubmit,
    "data-test-subj": "saveButton",
    onClick: onSubmitForm
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.configureFailureStoreModal.saveButtonLabel",
    defaultMessage: "Save"
  })))));
};
exports.ConfigureFailureStoreModal = ConfigureFailureStoreModal;