"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubobjectsParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _edit_field = require("../fields/edit_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubobjectsParameter = () => {
  return /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.subobjectsParameter.fieldTitle', {
      defaultMessage: 'Subobjects'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.subobjectsParameter.fieldDescription', {
      defaultMessage: 'Allow object to hold further subobjects. If disabled, documents can be stored with field names that contain dots and share common prefixes.'
    }),
    docLink: {
      text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.subobjectsDocLinkText', {
        defaultMessage: 'Subobjects documentation'
      }),
      href: _documentation.documentationService.getSubobjectsLink()
    },
    formFieldPath: "subobjects"
  });
};
exports.SubobjectsParameter = SubobjectsParameter;