"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepReviewContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../shared_imports");
var _step_review = require("./step_review");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepReviewContainer = exports.StepReviewContainer = /*#__PURE__*/_react.default.memo(({
  getComponentTemplateData,
  dataStreams,
  canRollover,
  dataStreamOptions
}) => {
  const {
    getData
  } = _shared_imports.Forms.useMultiContentContext();
  const wizardContent = getData();
  // Build the final template object, providing the wizard content data
  const componentTemplate = getComponentTemplateData(wizardContent);
  return /*#__PURE__*/_react.default.createElement(_step_review.StepReview, {
    dataStreams: dataStreams,
    canRollover: canRollover,
    componentTemplate: componentTemplate,
    dataStreamOptions: dataStreamOptions
  });
});