"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nTexts = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = exports.i18nTexts = {
  editPolicy: {
    shrinkActionLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.shrink.actionLabel', {
      defaultMessage: 'Shrink'
    }),
    shrinkToggleLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.shrink.enableShrinkLabel', {
      defaultMessage: 'Shrink index'
    }),
    shrinkCountLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.shrink.configureShardCountLabel', {
      defaultMessage: 'Configure shard count'
    }),
    shrinkNumberOfShardsLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.shrink.numberOfPrimaryShardsLabel', {
      defaultMessage: 'Number of primary shards'
    }),
    shrinkSizeLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.shrink.configureShardSizeLabel', {
      defaultMessage: 'Configure shard size'
    }),
    allowWriteAfterShrinkLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.shrink.allowWritesLabel', {
      defaultMessage: 'Allow writes after shrink'
    }),
    rolloverOffsetsHotPhaseTiming: _i18n.i18n.translate('xpack.indexLifecycleMgmt.rollover.rolloverOffsetsPhaseTimingDescription', {
      defaultMessage: 'How long it takes to reach the rollover criteria in the hot phase can vary.'
    }),
    searchableSnapshotInHotPhase: {
      searchableSnapshotDisallowed: {
        calloutTitle: _i18n.i18n.translate('xpack.indexLifecycleMgmt.searchableSnapshot.disallowedCalloutTitle', {
          defaultMessage: 'Searchable snapshot disabled'
        }),
        calloutBody: _i18n.i18n.translate('xpack.indexLifecycleMgmt.searchableSnapshot.disallowedCalloutBody', {
          defaultMessage: 'To use searchable snapshot in this phase you must disable searchable snapshot in the hot phase.'
        })
      }
    },
    forceMergeLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.forceMerge.enableText', {
      defaultMessage: 'Force merge'
    }),
    forceMergeEnabledFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.forcemerge.enableLabel', {
      defaultMessage: 'Force merge data'
    }),
    readonlyEnabledFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.readonlyFieldLabel', {
      defaultMessage: 'Make index read only'
    }),
    readonlyLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.readonlyTitle', {
      defaultMessage: 'Read only'
    }),
    downsampleEnabledFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.downsampleFieldLabel', {
      defaultMessage: 'Enable downsampling'
    }),
    downsampleIntervalFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.downsampleIntervalFieldLabel', {
      defaultMessage: 'Downsampling interval'
    }),
    downsampleIntervalFieldUnitsLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.downsampleIntervalFieldUnitsLabel', {
      defaultMessage: 'Downsampling interval units'
    }),
    maxNumSegmentsFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.forceMerge.numberOfSegmentsLabel', {
      defaultMessage: 'Number of segments'
    }),
    indexPriorityFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.indexPriorityLabel', {
      defaultMessage: 'Index priority'
    }),
    bestCompressionFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.forcemerge.bestCompressionLabel', {
      defaultMessage: 'Compress stored fields'
    }),
    bestCompressionFieldHelpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.forceMerge.bestCompressionText', {
      defaultMessage: 'Use higher compression for stored fields at the cost of slower performance.'
    }),
    allocationTypeOptionsFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.dataTierAllocation.allocationFieldLabel', {
      defaultMessage: 'Data tier options'
    }),
    allocationNodeAttributeFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.dataTierAllocation.nodeAllocationFieldLabel', {
      defaultMessage: 'Select a node attribute'
    }),
    searchableSnapshotsRepoFieldLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.searchableSnapshotRepoFieldLabel', {
      defaultMessage: 'Snapshot repository'
    }),
    maxPrimaryShardSizeLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.maximumPrimaryShardSizeLabel', {
      defaultMessage: 'Maximum primary shard size'
    }),
    maxPrimaryShardDocsLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.maximumPrimaryShardDocsLabel', {
      defaultMessage: 'Maximum docs in the primary shard'
    }),
    maxPrimaryShardSizeUnitsLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.maximumPrimaryShardSizeAriaLabel', {
      defaultMessage: 'Maximum shard size units'
    }),
    maxAgeLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.maximumAgeLabel', {
      defaultMessage: 'Maximum age'
    }),
    maxDocsLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.maximumDocumentsLabel', {
      defaultMessage: 'Maximum documents'
    }),
    maxSizeLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.maximumIndexSizeLabel', {
      defaultMessage: 'Maximum index size'
    }),
    downsampleLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.downsampleTitle', {
      defaultMessage: 'Downsample'
    }),
    minAgeLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.minimumAge.minimumAgeFieldLabel', {
      defaultMessage: 'Move data into phase when'
    }),
    rolloverLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.rolloverFieldTitle', {
      defaultMessage: 'Rollover'
    }),
    rolloverToolTipDescription: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.minimumAge.rolloverToolTipDescription', {
      defaultMessage: 'Data age is calculated from rollover. Rollover is configured in the hot phase.'
    }),
    minAgeUnitFieldSuffix: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.minimumAge.minimumAgeFieldSuffixLabel', {
      defaultMessage: 'old'
    }),
    replicasLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.numberOfReplicas.formRowTitle', {
      defaultMessage: 'Replicas'
    }),
    numberOfReplicasLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.numberOfReplicasLabel', {
      defaultMessage: 'Number of replicas'
    }),
    dataAllocationLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.common.dataTier.title', {
      defaultMessage: 'Data allocation'
    }),
    searchableSnapshotLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.fullyMountedSearchableSnapshotField.title', {
      defaultMessage: 'Searchable snapshot'
    }),
    waitForSnapshotLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.deletePhase.waitForSnapshotTitle', {
      defaultMessage: 'Wait for snapshot policy'
    }),
    deleteSearchableSnapshotLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.deletePhase.deleteSearchableSnapshotTitle', {
      defaultMessage: 'Delete searchable snapshot'
    }),
    errors: {
      numberRequired: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.numberRequiredErrorMessage', {
        defaultMessage: 'A number is required.'
      }),
      numberGreatThan0Required: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.numberAboveZeroRequiredError', {
        defaultMessage: 'Only numbers above 0 are allowed.'
      }),
      integerRequired: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.integerRequiredError', {
        defaultMessage: 'Only integers are allowed.'
      }),
      maximumAgeRequiredMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.maximumAgeMissingError', {
        defaultMessage: 'A maximum age is required.'
      }),
      maximumSizeRequiredMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.maximumIndexSizeMissingError', {
        defaultMessage: 'A maximum index size is required.'
      }),
      maximumDocumentsRequiredMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.maximumDocumentsMissingError', {
        defaultMessage: 'Maximum documents is required.'
      }),
      maximumPrimaryShardSizeRequiredMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.maximumPrimaryShardSizeMissingError', {
        defaultMessage: 'A maximum primary shard size is required'
      }),
      maximumPrimaryShardDocsRequiredMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.maximumPrimaryShardDocsMissingError', {
        defaultMessage: 'Maximum documents in the primary shard is required'
      }),
      rollOverConfigurationCallout: {
        title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.rolloverConfigurationError.title', {
          defaultMessage: 'Invalid rollover configuration'
        }),
        body: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.rolloverConfigurationError.body', {
          defaultMessage: 'A value for one of maximum primary shard size, maximum documents, maximum age or maximum index size is required.'
        })
      },
      nonNegativeNumberRequired: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.nonNegativeNumberRequiredError', {
        defaultMessage: 'Only non-negative numbers are allowed.'
      }),
      policyNameContainsInvalidChars: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.errors.policyNameContainsInvalidCharsError', {
        defaultMessage: 'A policy name cannot contain spaces or commas.'
      }),
      policyNameAlreadyUsedErrorMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.policyNameAlreadyUsedError', {
        defaultMessage: 'That policy name is already used.'
      }),
      policyNameMustBeDifferentErrorMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.differentPolicyNameRequiredError', {
        defaultMessage: 'The policy name must be different.'
      }),
      policyNameRequiredMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.policyNameRequiredError', {
        defaultMessage: 'A policy name is required.'
      }),
      policyNameStartsWithUnderscoreErrorMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.policyNameStartsWithUnderscoreError', {
        defaultMessage: 'A policy name cannot start with an underscore.'
      }),
      policyNameTooLongErrorMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.policyNameTooLongError', {
        defaultMessage: 'A policy name cannot be longer than 255 bytes.'
      }),
      searchableSnapshotRepoRequired: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.searchableSnapshotRepoRequiredError', {
        defaultMessage: 'A snapshot repository name is required.'
      })
    },
    titles: {
      hot: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.hotPhase.hotPhaseTitle', {
        defaultMessage: 'Hot phase'
      }),
      warm: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.warmPhase.warmPhaseTitle', {
        defaultMessage: 'Warm phase'
      }),
      cold: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.coldPhase.coldPhaseTitle', {
        defaultMessage: 'Cold phase'
      }),
      frozen: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.frozenPhase.frozenPhaseTitle', {
        defaultMessage: 'Frozen phase'
      }),
      delete: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.deletePhase.deletePhaseTitle', {
        defaultMessage: 'Delete phase'
      })
    },
    descriptions: {
      hot: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.hotPhase.hotPhaseDescription', {
        defaultMessage: 'Store your most recent, most frequently-searched data in the hot tier. The hot tier provides the best indexing and search performance by using the most powerful, expensive hardware.'
      }),
      warm: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.warmPhase.warmPhaseDescription', {
        defaultMessage: 'Move data to the warm tier when you are still likely to search it, but infrequently need to update it. The warm tier is optimized for search performance over indexing performance.'
      }),
      cold: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.coldPhase.coldPhaseDescription', {
        defaultMessage: 'Move data to the cold tier when you are searching it less often and don’t need to update it. The cold tier is optimized for cost savings over search performance.'
      }),
      frozen: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.frozenPhase.frozenPhaseDescription', {
        defaultMessage: 'Move data to the frozen tier for long term retention. The frozen tier provides the most cost-effective way store your data and still be able to search it.'
      }),
      delete: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.deletePhase.deletePhaseDescription', {
        defaultMessage: 'Delete data you no longer need.'
      })
    }
  }
};