"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUsingDefaultRollover = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isUsingDefaultRollover = policy => {
  var _policy$phases, _policy$phases$hot, _policy$phases$hot$ac;
  const rollover = policy === null || policy === void 0 ? void 0 : (_policy$phases = policy.phases) === null || _policy$phases === void 0 ? void 0 : (_policy$phases$hot = _policy$phases.hot) === null || _policy$phases$hot === void 0 ? void 0 : (_policy$phases$hot$ac = _policy$phases$hot.actions) === null || _policy$phases$hot$ac === void 0 ? void 0 : _policy$phases$hot$ac.rollover;
  return Boolean(rollover && rollover.max_age === _constants.defaultRolloverAction.max_age && rollover.max_docs === _constants.defaultRolloverAction.max_docs && rollover.max_primary_shard_size === _constants.defaultRolloverAction.max_primary_shard_size && rollover.max_primary_shard_docs === _constants.defaultRolloverAction.max_primary_shard_docs);
};
exports.isUsingDefaultRollover = isUsingDefaultRollover;