"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createValidateUrl = createValidateUrl;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SAFE_URL_PATTERN = /^(?:(?:https?):|[^&:/?#]*(?:[/?#]|$))/gi;
const generalFormatError = _i18n.i18n.translate('imageEmbeddable.imageEditor.urlFormatGeneralErrorMessage', {
  defaultMessage: 'Invalid format. Example: {exampleUrl}',
  values: {
    exampleUrl: 'https://elastic.co/my-image.png'
  }
});
const externalUrlError = _i18n.i18n.translate('imageEmbeddable.imageEditor.urlFormatExternalErrorMessage', {
  defaultMessage: 'This URL is not allowed by your administrator. Refer to "externalUrl.policy" configuration.'
});
function createValidateUrl(externalUrl) {
  return url => {
    if (!url) return {
      isValid: false,
      error: generalFormatError
    };
    try {
      new URL(url);
      if (!url.match(SAFE_URL_PATTERN)) throw new Error();
      const isExternalUrlValid = !!externalUrl.validateUrl(url);
      if (!isExternalUrlValid) {
        return {
          isValid: false,
          error: externalUrlError
        };
      }
      return {
        isValid: true
      };
    } catch (e) {
      return {
        isValid: false,
        error: generalFormatError
      };
    }
  };
}