"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useImageViewerContext = exports.ImageViewerContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ImageViewerContext = exports.ImageViewerContext = /*#__PURE__*/(0, _react.createContext)(null);
const useImageViewerContext = () => {
  const ctx = (0, _react.useContext)(ImageViewerContext);
  if (!ctx) {
    throw new Error('ImageViewerContext is not found!');
  }
  return ctx;
};
exports.useImageViewerContext = useImageViewerContext;