"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.colorChoices = void 0;
exports.getIcon = getIcon;
exports.getSuitableIcon = void 0;
exports.getTemplateIcon = getTemplateIcon;
exports.iconChoicesByClass = exports.iconChoices = void 0;
exports.isNewIcon = isNewIcon;
exports.urlTemplateIconChoicesByClass = exports.urlTemplateIconChoices = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const iconChoices = exports.iconChoices = [{
  id: 'folderOpen',
  prevName: 'fa-folder-open-o',
  package: 'eui',
  patterns: [/category/i, /folder/i, /group/i],
  label: _i18n.i18n.translate('xpack.graph.icon.folderOpen', {
    defaultMessage: 'Folder open'
  })
}, {
  id: 'kubernetesPod',
  prevName: 'fa-cube',
  package: 'eui',
  patterns: [/prod/i, /sku/i],
  label: _i18n.i18n.translate('xpack.graph.icon.cube', {
    defaultMessage: 'Cube'
  })
}, {
  id: 'key',
  prevName: 'fa-key',
  package: 'eui',
  patterns: [/key/i],
  label: _i18n.i18n.translate('xpack.graph.icon.key', {
    defaultMessage: 'Key'
  })
}, {
  id: 'town_hall',
  prevName: 'fa-bank',
  package: 'maki',
  patterns: [/bank/i, /account/i],
  label: _i18n.i18n.translate('xpack.graph.icon.bank', {
    defaultMessage: 'Bank'
  })
}, {
  id: 'car',
  prevName: 'fa-automobile',
  package: 'maki',
  patterns: [/car/i, /veh/i],
  label: _i18n.i18n.translate('xpack.graph.icon.automobile', {
    defaultMessage: 'Automobile'
  })
}, {
  id: 'home',
  prevName: 'fa-home',
  package: 'eui',
  patterns: [/address/i, /home/i],
  label: _i18n.i18n.translate('xpack.graph.icon.home', {
    defaultMessage: 'Home'
  })
}, {
  id: 'question',
  prevName: 'fa-question',
  package: 'eui',
  patterns: [/query/i, /search/i],
  label: _i18n.i18n.translate('xpack.graph.icon.question', {
    defaultMessage: 'Question'
  })
}, {
  id: 'airport',
  prevName: 'fa-plane',
  package: 'maki',
  patterns: [/flight/i, /plane/i],
  label: _i18n.i18n.translate('xpack.graph.icon.plane', {
    defaultMessage: 'Plane'
  })
}, {
  id: 'document',
  prevName: 'fa-file-o',
  package: 'eui',
  patterns: [/file/i, /doc/i],
  label: _i18n.i18n.translate('xpack.graph.icon.file', {
    defaultMessage: 'File open'
  })
}, {
  id: 'user',
  prevName: 'fa-user',
  package: 'eui',
  patterns: [/user/i, /person/i, /people/i, /owner/i, /cust/i, /participant/i, /party/i, /member/i],
  label: _i18n.i18n.translate('xpack.graph.icon.user', {
    defaultMessage: 'User'
  })
}, {
  id: 'users',
  prevName: 'fa-users',
  package: 'eui',
  patterns: [/group/i, /team/i, /meeting/i],
  label: _i18n.i18n.translate('xpack.graph.icon.users', {
    defaultMessage: 'Users'
  })
}, {
  id: 'music',
  prevName: 'fa-music',
  package: 'maki',
  patterns: [/artist/i, /sound/i, /music/i],
  label: _i18n.i18n.translate('xpack.graph.icon.music', {
    defaultMessage: 'Music'
  })
}, {
  id: 'flag',
  prevName: 'fa-flag',
  package: 'eui',
  patterns: [/country/i, /warn/i, /flag/i],
  label: _i18n.i18n.translate('xpack.graph.icon.flag', {
    defaultMessage: 'Flag'
  })
}, {
  id: 'tag',
  prevName: 'fa-flag',
  package: 'eui',
  patterns: [/tag/i, /label/i],
  label: 'Tag'
}, {
  id: 'telephone',
  prevName: 'fa-phone',
  package: 'maki',
  patterns: [/phone/i],
  label: _i18n.i18n.translate('xpack.graph.icon.phone', {
    defaultMessage: 'Phone'
  })
}, {
  id: 'desktop',
  prevName: 'fa-desktop',
  package: 'eui',
  patterns: [/host/i, /server/i],
  label: _i18n.i18n.translate('xpack.graph.icon.desktop', {
    defaultMessage: 'Desktop'
  })
}, {
  id: 'lettering',
  prevName: 'fa-font',
  package: 'eui',
  patterns: [/text/i, /title/i, /body/i, /desc/i],
  label: _i18n.i18n.translate('xpack.graph.icon.font', {
    defaultMessage: 'Font'
  })
}, {
  id: 'at',
  prevName: 'fa-at',
  package: 'eui',
  patterns: [/account/i, /email/i],
  label: _i18n.i18n.translate('xpack.graph.icon.at', {
    defaultMessage: 'At'
  })
}, {
  id: 'heart',
  prevName: 'fa-heart',
  package: 'eui',
  patterns: [/like/i, /favourite/i, /favorite/i],
  label: _i18n.i18n.translate('xpack.graph.icon.heart', {
    defaultMessage: 'Heart'
  })
}, {
  id: 'bolt',
  prevName: 'fa-bolt',
  package: 'eui',
  patterns: [/action/i],
  label: _i18n.i18n.translate('xpack.graph.icon.bolt', {
    defaultMessage: 'Bolt'
  })
}, {
  id: 'mapMarker',
  prevName: 'fa-map-marker',
  package: 'eui',
  patterns: [/location/i, /geo/i, /position/i],
  label: _i18n.i18n.translate('xpack.graph.icon.mapMarker', {
    defaultMessage: 'Map marker'
  })
}, {
  id: 'warning',
  prevName: 'fa-exclamation',
  package: 'eui',
  patterns: [/risk/i, /error/i, /warn/i],
  label: _i18n.i18n.translate('xpack.graph.icon.exclamation', {
    defaultMessage: 'Exclamation'
  })
}, {
  id: 'industry',
  prevName: 'fa-industry',
  package: 'maki',
  patterns: [/business/i, /company/i, /industry/i, /organisation/i],
  label: _i18n.i18n.translate('xpack.graph.icon.industry', {
    defaultMessage: 'Industry'
  })
}];
const getSuitableIcon = fieldName => iconChoices.find(choice => {
  var _choice$patterns;
  return (_choice$patterns = choice.patterns) === null || _choice$patterns === void 0 ? void 0 : _choice$patterns.some(pattern => pattern.test(fieldName));
}) || iconChoices[0];
exports.getSuitableIcon = getSuitableIcon;
const iconChoicesByClass = exports.iconChoicesByClass = {};
iconChoices.forEach(icon => {
  iconChoicesByClass[icon.id] = icon;
});
const urlTemplateIconChoices = exports.urlTemplateIconChoices = [
// Patterns are used to help default icon choices for common field names
{
  id: 'visLine',
  prevName: 'fa-line-chart',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.lineChart', {
    defaultMessage: 'Line chart'
  })
}, {
  id: 'visPie',
  prevName: 'fa-pie-chart',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.pieChart', {
    defaultMessage: 'Pie chart'
  })
}, {
  id: 'visArea',
  prevName: 'fa-area-chart',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.areaChart', {
    defaultMessage: 'Area chart'
  })
}, {
  id: 'visBarVertical',
  prevName: 'fa-bar-chart',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.barChart', {
    defaultMessage: 'Bar chart'
  })
}, {
  id: 'globe',
  prevName: 'fa-globe',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.globe', {
    defaultMessage: 'Globe'
  })
}, {
  id: 'document',
  prevName: 'fa-file-text-o',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.fileText', {
    defaultMessage: 'File'
  })
}, {
  id: 'search',
  prevName: 'fa-google',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.search', {
    defaultMessage: 'Search'
  })
}, {
  id: 'eye',
  prevName: 'fa-eye',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.eye', {
    defaultMessage: 'Eye'
  })
}, {
  id: 'visGauge',
  prevName: 'fa-tachimeter',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.tachometer', {
    defaultMessage: 'Tachometer'
  })
}, {
  id: 'info',
  prevName: 'fa-info',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.info', {
    defaultMessage: 'Info'
  })
}, {
  id: 'link',
  prevName: 'fa-external-link',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.externalLink', {
    defaultMessage: 'External link'
  })
}, {
  id: 'visTable',
  prevName: 'fa-table',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.table', {
    defaultMessage: 'Table'
  })
}, {
  id: 'list',
  prevName: 'fa-list',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.list', {
    defaultMessage: 'List'
  })
}, {
  id: 'cluster',
  prevName: 'fa-share-alt',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.shareAlt', {
    defaultMessage: 'Share'
  })
}];
const urlTemplateIconChoicesByClass = exports.urlTemplateIconChoicesByClass = {};
urlTemplateIconChoices.forEach(icon => {
  urlTemplateIconChoicesByClass[icon.id] = icon;
});
const colorChoices = exports.colorChoices = (0, _eui.euiPaletteColorBlind)();
function hasIcon(icon) {
  return icon != null;
}
function isNewIcon(icon) {
  if (!hasIcon(icon)) {
    return false;
  }
  return typeof icon !== 'string' ? 'package' in icon : iconChoices.some(({
    id
  }) => id === icon);
}
function getIcon(icon) {
  if (isNewIcon(icon)) {
    return typeof icon === 'string' ? iconChoicesByClass[icon] : icon;
  }
  return getIconFromList(icon, iconChoices);
}
function getTemplateIcon(icon) {
  if (isNewIcon(icon)) {
    return typeof icon === 'string' ? urlTemplateIconChoicesByClass[icon] : icon;
  }
  return getIconFromList(icon, urlTemplateIconChoices);
}
const EMPTY_ICON = {
  id: 'empty',
  prevName: '',
  package: 'eui',
  label: _i18n.i18n.translate('xpack.graph.icon.empty', {
    defaultMessage: 'Empty icon'
  })
};
function getIconFromList(icon, list) {
  if (!hasIcon(icon)) {
    return EMPTY_ICON;
  }
  const iconName = typeof icon === 'string' ? icon : icon.class;
  const newIcon = list.find(({
    prevName
  }) => prevName === iconName);
  return newIcon !== null && newIcon !== void 0 ? newIcon : EMPTY_ICON;
}