"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asSyncedObservable = asSyncedObservable;
var Rx = _interopRequireWildcard(require("rxjs"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a helper to tie state updates that happen somewhere else back to an react state.
 * It is roughly comparable to `reactDirective`, but does not have to be used from within a
 * template.
 *
 * This is a temporary solution until the state of Workspace internals is moved outside
 * of mutable object to the redux state (at least blocklistedNodes, canEditDrillDownUrls and
 * unblocklist action in this case).
 *
 * @param collectProps Function that collects properties from the scope that should be passed
 * into the observable. All functions passed along will be wrapped to cause a react render
 * and refresh the observable afterwards with a new call to `collectProps`. By doing so, react
 * will receive an update outside of it local state and the results are passed back via the observable.
 */
function asSyncedObservable(collectProps) {
  const boundCollectProps = () => {
    const collectedProps = collectProps();
    Object.keys(collectedProps).forEach(key => {
      const currentValue = collectedProps[key];
      if (typeof currentValue === 'function') {
        collectedProps[key] = (...args) => {
          currentValue(...args);
          subject$.next(boundCollectProps());
        };
      }
    });
    return collectedProps;
  };
  const subject$ = new Rx.BehaviorSubject(boundCollectProps());
  return subject$.asObservable();
}