"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostEnrollmentAPIKeyRequestSchema = exports.GetOneEnrollmentAPIKeyRequestSchema = exports.GetEnrollmentAPIKeysRequestSchema = exports.DeleteEnrollmentAPIKeyRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../constants");
var _constants2 = require("../../../common/constants");
var _filter_utils = require("../../routes/utils/filter_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetEnrollmentAPIKeysRequestSchema = exports.GetEnrollmentAPIKeysRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.number({
      defaultValue: 1
    }),
    perPage: _configSchema.schema.number({
      defaultValue: 20
    }),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: value => {
        const validationObj = (0, _filter_utils.validateKuery)(value, [_constants2.FLEET_ENROLLMENT_API_PREFIX], _constants.ENROLLMENT_API_KEY_MAPPINGS, true);
        if (validationObj !== null && validationObj !== void 0 && validationObj.error) {
          return validationObj === null || validationObj === void 0 ? void 0 : validationObj.error;
        }
      }
    }))
  })
};
const GetOneEnrollmentAPIKeyRequestSchema = exports.GetOneEnrollmentAPIKeyRequestSchema = {
  params: _configSchema.schema.object({
    keyId: _configSchema.schema.string()
  })
};
const DeleteEnrollmentAPIKeyRequestSchema = exports.DeleteEnrollmentAPIKeyRequestSchema = {
  params: _configSchema.schema.object({
    keyId: _configSchema.schema.string()
  })
};
const PostEnrollmentAPIKeyRequestSchema = exports.PostEnrollmentAPIKeyRequestSchema = {
  body: _configSchema.schema.object({
    name: _configSchema.schema.maybe(_configSchema.schema.string()),
    policy_id: _configSchema.schema.string(),
    expiration: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};