"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensurePreconfiguredFleetProxies = ensurePreconfiguredFleetProxies;
exports.getPreconfiguredFleetProxiesFromConfig = getPreconfiguredFleetProxiesFromConfig;
var _lodash = require("lodash");
var _pMap = _interopRequireDefault(require("p-map"));
var _fleet_proxies = require("../fleet_proxies");
var _fleet_server_host = require("../fleet_server_host");
var _agent_policy = require("../agent_policy");
var _output = require("../output");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPreconfiguredFleetProxiesFromConfig(config) {
  const {
    proxies: fleetProxiesFromConfig
  } = config;
  return fleetProxiesFromConfig.map(proxyConfig => ({
    ...proxyConfig,
    is_preconfigured: true
  }));
}
function hasChanged(existingProxy, preconfiguredFleetProxy) {
  var _ref, _ref2, _ref3, _ref4, _ref5, _ref6, _existingProxy$proxy_, _preconfiguredFleetPr;
  return (_ref = (_ref2 = (_ref3 = (_ref4 = (_ref5 = (_ref6 = !existingProxy.is_preconfigured || existingProxy.name !== existingProxy.name || existingProxy.url !== preconfiguredFleetProxy.name || !(0, _lodash.isEqual)((_existingProxy$proxy_ = existingProxy.proxy_headers) !== null && _existingProxy$proxy_ !== void 0 ? _existingProxy$proxy_ : null, (_preconfiguredFleetPr = preconfiguredFleetProxy.proxy_headers) !== null && _preconfiguredFleetPr !== void 0 ? _preconfiguredFleetPr : null) || existingProxy.certificate_authorities) !== null && _ref6 !== void 0 ? _ref6 : null !== preconfiguredFleetProxy.certificate_authorities) !== null && _ref5 !== void 0 ? _ref5 : null || existingProxy.certificate) !== null && _ref4 !== void 0 ? _ref4 : null !== preconfiguredFleetProxy.certificate) !== null && _ref3 !== void 0 ? _ref3 : null || existingProxy.certificate_key) !== null && _ref2 !== void 0 ? _ref2 : null !== preconfiguredFleetProxy.certificate_key) !== null && _ref !== void 0 ? _ref : null;
}
async function createOrUpdatePreconfiguredFleetProxies(soClient, esClient, preconfiguredFleetProxies) {
  const existingFleetProxies = await (0, _fleet_proxies.bulkGetFleetProxies)(soClient, preconfiguredFleetProxies.map(({
    id
  }) => id), {
    ignoreNotFound: true
  });
  await Promise.all(preconfiguredFleetProxies.map(async preconfiguredFleetProxy => {
    const existingProxy = existingFleetProxies.find(fleetProxy => fleetProxy.id === preconfiguredFleetProxy.id);
    const {
      id,
      ...data
    } = preconfiguredFleetProxy;
    const isCreate = !existingProxy;
    const isUpdateWithNewData = existingProxy ? hasChanged(existingProxy, preconfiguredFleetProxy) : false;
    if (isCreate) {
      await (0, _fleet_proxies.createFleetProxy)(soClient, {
        ...data,
        is_preconfigured: true
      }, {
        id,
        overwrite: true,
        fromPreconfiguration: true
      });
    } else if (isUpdateWithNewData) {
      await (0, _fleet_proxies.updateFleetProxy)(soClient, id, {
        ...data,
        is_preconfigured: true
      }, {
        fromPreconfiguration: true
      });
      // Bump all the agent policy that use that proxy
      const [{
        items: fleetServerHosts
      }, {
        items: outputs
      }] = await Promise.all([(0, _fleet_server_host.listFleetServerHostsForProxyId)(soClient, id), _output.outputService.listAllForProxyId(soClient, id)]);
      if (fleetServerHosts.some(host => host.is_default) || outputs.some(output => output.is_default || output.is_default_monitoring)) {
        await _agent_policy.agentPolicyService.bumpAllAgentPolicies(esClient);
      } else {
        await (0, _pMap.default)(outputs, output => _agent_policy.agentPolicyService.bumpAllAgentPoliciesForOutput(esClient, output.id), {
          concurrency: 20
        });
        await (0, _pMap.default)(fleetServerHosts, fleetServerHost => _agent_policy.agentPolicyService.bumpAllAgentPoliciesForFleetServerHosts(esClient, fleetServerHost.id), {
          concurrency: 20
        });
      }
    }
  }));
}
async function cleanPreconfiguredFleetProxies(soClient, esClient, preconfiguredFleetProxies) {
  const existingFleetProxies = await (0, _fleet_proxies.listFleetProxies)(soClient);
  const existingPreconfiguredFleetProxies = existingFleetProxies.items.filter(o => o.is_preconfigured === true);
  for (const existingFleetProxy of existingPreconfiguredFleetProxies) {
    const hasBeenDelete = !preconfiguredFleetProxies.find(({
      id
    }) => existingFleetProxy.id === id);
    if (!hasBeenDelete) {
      continue;
    }
    const [{
      items: fleetServerHosts
    }, {
      items: outputs
    }] = await Promise.all([(0, _fleet_server_host.listFleetServerHostsForProxyId)(soClient, existingFleetProxy.id), _output.outputService.listAllForProxyId(soClient, existingFleetProxy.id)]);
    const isUsed = fleetServerHosts.length > 0 || outputs.length > 0;
    if (isUsed) {
      await (0, _fleet_proxies.updateFleetProxy)(soClient, existingFleetProxy.id, {
        is_preconfigured: false
      }, {
        fromPreconfiguration: true
      });
    } else {
      await (0, _fleet_proxies.deleteFleetProxy)(soClient, esClient, existingFleetProxy.id, {
        fromPreconfiguration: true
      });
    }
  }
}
async function ensurePreconfiguredFleetProxies(soClient, esClient, preconfiguredFleetProxies) {
  await createOrUpdatePreconfiguredFleetProxies(soClient, esClient, preconfiguredFleetProxies);
  await cleanPreconfiguredFleetProxies(soClient, esClient, preconfiguredFleetProxies);
}