"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepUpdateCurrentWriteIndices = stepUpdateCurrentWriteIndices;
var _template = require("../../../elasticsearch/template/template");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepUpdateCurrentWriteIndices(context) {
  const {
    esClient,
    logger,
    ignoreMappingUpdateErrors,
    skipDataStreamRollover,
    indexTemplates
  } = context;

  // update current backing indices of each data stream
  await (0, _utils.withPackageSpan)('Update write indices', () => (0, _template.updateCurrentWriteIndices)(esClient, logger, indexTemplates || [], {
    ignoreMappingUpdateErrors,
    skipDataStreamRollover
  }));
}