"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndex = fetchIndex;
exports.fetchSavedObjectNames = fetchSavedObjectNames;
exports.fetchSavedObjects = fetchSavedObjects;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchIndex(esClient, index) {
  return esClient.search({
    index
  });
}
async function fetchSavedObjects(soClient, type, name) {
  return soClient.find({
    type,
    search: `\"${name}\"`,
    // Search for phrase
    searchFields: ['name'] // SO type automatically inferred
  });
}
async function fetchSavedObjectNames(soClient, type) {
  return soClient.find({
    type,
    aggs: {
      names: {
        terms: {
          field: `${type}.attributes.name`
        } // cf. SavedObjectsFindOptions definition in src/core/packages/saved-objects/api-server/src/apis/find.ts
      }
    }
  });
}