"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamService = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_STREAM_INDEX_PATTERN = 'logs-*-*,metrics-*-*,traces-*-*,synthetics-*-*,profiling-*';
class DataStreamService {
  async getAllFleetDataStreams(esClient) {
    const {
      data_streams: dataStreamsInfo
    } = await esClient.indices.getDataStream({
      name: DATA_STREAM_INDEX_PATTERN
    });
    return dataStreamsInfo;
  }
  async getAllFleetMeteringStats(esClient) {
    var _res$datastreams;
    const res = await esClient.transport.request({
      path: `/_metering/stats`,
      method: 'GET',
      querystring: {
        human: true
      }
    });
    return (_res$datastreams = res.datastreams) !== null && _res$datastreams !== void 0 ? _res$datastreams : [];
  }
  async getAllFleetDataStreamsStats(esClient) {
    const {
      data_streams: dataStreamStats
    } = await esClient.indices.dataStreamsStats({
      name: DATA_STREAM_INDEX_PATTERN,
      human: true
    });
    return dataStreamStats;
  }
  streamPartsToIndexPattern({
    type,
    dataset
  }) {
    return `${type}-${dataset}-*`;
  }
  async getMatchingDataStreams(esClient, dataStreamParts) {
    try {
      const {
        data_streams: dataStreamsInfo
      } = await esClient.indices.getDataStream({
        name: this.streamPartsToIndexPattern(dataStreamParts)
      });
      return dataStreamsInfo;
    } catch (e) {
      if (e.statusCode === 404) {
        return [];
      }
      throw e;
    }
  }
  async getMatchingIndexTemplate(esClient, dataStreamParts) {
    try {
      var _indexTemplates$;
      const {
        index_templates: indexTemplates
      } = await esClient.indices.getIndexTemplate({
        name: `${dataStreamParts.type}-${dataStreamParts.dataset}`
      });
      return (_indexTemplates$ = indexTemplates[0]) === null || _indexTemplates$ === void 0 ? void 0 : _indexTemplates$.index_template;
    } catch (e) {
      if (e.statusCode === 404) {
        return null;
      }
      throw e;
    }
  }
}
const dataStreamService = exports.dataStreamService = new DataStreamService();