"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rotateKeyPairHandler = void 0;
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rotateKeyPairHandler = async (_, __, response) => {
  const logger = _services.appContextService.getLogger();
  const messageSigningService = _services.appContextService.getMessageSigningService();
  if (!messageSigningService) {
    const errorMessage = 'Failed to rotate key pair. Message signing service is unavailable!';
    logger.error(errorMessage);
    return response.customError({
      statusCode: 500,
      body: {
        message: errorMessage
      }
    });
  }
  try {
    await messageSigningService.rotateKeyPair();
    return response.ok({
      body: {
        message: 'Key pair rotated successfully.'
      }
    });
  } catch (error) {
    logger.error(error);
    throw new Error('Failed to rotate key pair!');
  }
};
exports.rotateKeyPairHandler = rotateKeyPairHandler;