"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postNewAgentActionHandlerBuilder = exports.postCancelActionHandlerBuilder = void 0;
var _get_current_namespace = require("../../services/spaces/get_current_namespace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// handlers that handle agent actions request

const postNewAgentActionHandlerBuilder = function (actionsService) {
  return async (context, request, response) => {
    const core = await context.core;
    const esClient = core.elasticsearch.client.asInternalUser;
    const soClient = core.savedObjects.client;
    const agent = await actionsService.getAgent(esClient, soClient, request.params.agentId);
    const newAgentAction = request.body.action;
    const savedAgentAction = await actionsService.createAgentAction(esClient, {
      created_at: new Date().toISOString(),
      ...newAgentAction,
      agents: [agent.id],
      namespaces: [(0, _get_current_namespace.getCurrentNamespace)(soClient)]
    });
    const body = {
      item: savedAgentAction
    };
    return response.ok({
      body
    });
  };
};
exports.postNewAgentActionHandlerBuilder = postNewAgentActionHandlerBuilder;
const postCancelActionHandlerBuilder = function (actionsService) {
  return async (context, request, response) => {
    const core = await context.core;
    const esClient = core.elasticsearch.client.asInternalUser;
    const soClient = core.savedObjects.client;
    const action = await actionsService.cancelAgentAction(esClient, soClient, request.params.actionId);
    const body = {
      item: action
    };
    return response.ok({
      body
    });
  };
};
exports.postCancelActionHandlerBuilder = postCancelActionHandlerBuilder;