"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFleetDeepLinks = exports.FleetDeepLinkId = void 0;
var _i18n = require("@kbn/i18n");
var _page_paths = require("./constants/page_paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FleetDeepLinkId = exports.FleetDeepLinkId = /*#__PURE__*/function (FleetDeepLinkId) {
  FleetDeepLinkId["agents"] = "agents";
  FleetDeepLinkId["policies"] = "policies";
  FleetDeepLinkId["enrollmentTokens"] = "enrollment_tokens";
  FleetDeepLinkId["uninstallTokens"] = "uninstall_tokens";
  FleetDeepLinkId["dataStreams"] = "data_streams";
  FleetDeepLinkId["settings"] = "settings";
  return FleetDeepLinkId;
}({});
const getFleetDeepLinks = (experimentalFeatures, authz) => {
  return [{
    id: FleetDeepLinkId.agents,
    title: _i18n.i18n.translate('xpack.fleet.deepLinks.agents.title', {
      defaultMessage: 'Agents'
    }),
    path: _page_paths.FLEET_ROUTING_PATHS.agents,
    visibleIn: !(authz !== null && authz !== void 0 && authz.fleet.readAgents) ? [] : ['globalSearch']
  }, {
    id: FleetDeepLinkId.policies,
    title: _i18n.i18n.translate('xpack.fleet.deepLinks.policies.title', {
      defaultMessage: 'Agent policies'
    }),
    path: _page_paths.FLEET_ROUTING_PATHS.policies,
    visibleIn: !(authz !== null && authz !== void 0 && authz.fleet.readAgentPolicies) ? [] : ['globalSearch']
  }, {
    id: FleetDeepLinkId.enrollmentTokens,
    title: _i18n.i18n.translate('xpack.fleet.deepLinks.enrollmentTokens.title', {
      defaultMessage: 'Enrollment tokens'
    }),
    path: _page_paths.FLEET_ROUTING_PATHS.enrollment_tokens,
    visibleIn: !(authz !== null && authz !== void 0 && authz.fleet.allAgents) ? [] : ['globalSearch']
  }, ...(experimentalFeatures.agentTamperProtectionEnabled ? [{
    id: FleetDeepLinkId.uninstallTokens,
    title: _i18n.i18n.translate('xpack.fleet.deepLinks.uninstallTokens.title', {
      defaultMessage: 'Uninstall tokens'
    }),
    path: _page_paths.FLEET_ROUTING_PATHS.uninstall_tokens,
    visibleIn: !(authz !== null && authz !== void 0 && authz.fleet.allAgents) ? [] : ['globalSearch']
  }] : []), {
    id: FleetDeepLinkId.dataStreams,
    title: _i18n.i18n.translate('xpack.fleet.deepLinks.dataStreams.title', {
      defaultMessage: 'Data streams'
    }),
    path: _page_paths.FLEET_ROUTING_PATHS.data_streams
  }, {
    id: FleetDeepLinkId.settings,
    title: _i18n.i18n.translate('xpack.fleet.deepLinks.settings.title', {
      defaultMessage: 'Settings'
    }),
    path: _page_paths.FLEET_ROUTING_PATHS.settings,
    visibleIn: !(authz !== null && authz !== void 0 && authz.fleet.readSettings) ? [] : ['globalSearch']
  }];
};
exports.getFleetDeepLinks = getFleetDeepLinks;