"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeepPoliciesUpToDateSwitch = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KeepPoliciesUpToDateSwitch = ({
  checked,
  disabled = false,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
  label: _i18n.i18n.translate('xpack.fleet.integrations.settings.keepIntegrationPoliciesUpToDateLabel', {
    defaultMessage: 'Keep integration policies up to date automatically'
  }),
  checked: checked,
  onChange: onChange,
  disabled: disabled
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "info"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, disabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.integrations.settings.keepIntegrationPoliciesUpToDateDisabledDescription",
  defaultMessage: "This integration requires Fleet to automatically upgrade its integration policies"
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.integrations.settings.keepIntegrationPoliciesUpToDateDescription",
  defaultMessage: "When enabled, Fleet will attempt to upgrade and deploy integration policies automatically"
})))));
exports.KeepPoliciesUpToDateSwitch = KeepPoliciesUpToDateSwitch;