"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tags = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _utils = require("../agent_list_page/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapped = _styledComponents.default.div`
  display: flex;
  .wrappedText {
    white-space: pre-wrap;
  }
`;
// Number of tags displayed before "+ N more" is displayed
const MAX_TAGS_TO_DISPLAY = 3;
const Tags = ({
  tags,
  color,
  size
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Wrapped, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: 'wrappedText',
    content: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "agentTagsTooltip"
    }, tags.join(', '))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: size,
    color: color
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "agentTags"
  }, (0, _lodash.take)(tags, 3).map(_utils.truncateTag).join(', '), tags.length > MAX_TAGS_TO_DISPLAY ? ` + ${tags.length - MAX_TAGS_TO_DISPLAY} more` : '')))));
};
exports.Tags = Tags;