"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectLogLevel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectLogLevel = exports.SelectLogLevel = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicyLogLevel = _constants.DEFAULT_LOG_LEVEL
}) => {
  var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3, _agent$local_metadata4, _agent$local_metadata5, _agent$local_metadata6, _agent$local_metadata7;
  const authz = (0, _hooks.useAuthz)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isSetLevelLoading, setIsSetLevelLoading] = (0, _react.useState)(false);
  const [isResetLevelLoading, setIsResetLevelLoading] = (0, _react.useState)(false);
  const canResetLogLevel = (0, _gte.default)((_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.version, '8.15.0', true);
  const [agentLogLevel, setAgentLogLevel] = (0, _react.useState)((_agent$local_metadata4 = (_agent$local_metadata5 = agent.local_metadata) === null || _agent$local_metadata5 === void 0 ? void 0 : (_agent$local_metadata6 = _agent$local_metadata5.elastic) === null || _agent$local_metadata6 === void 0 ? void 0 : (_agent$local_metadata7 = _agent$local_metadata6.agent) === null || _agent$local_metadata7 === void 0 ? void 0 : _agent$local_metadata7.log_level) !== null && _agent$local_metadata4 !== void 0 ? _agent$local_metadata4 : _constants.DEFAULT_LOG_LEVEL);
  const [selectedLogLevel, setSelectedLogLevel] = (0, _react.useState)(agentLogLevel);
  const resetLogLevel = (0, _react.useCallback)(() => {
    setIsResetLevelLoading(true);
    async function send() {
      try {
        const res = await (0, _hooks.sendPostAgentAction)(agent.id, {
          action: {
            type: 'SETTINGS',
            data: {
              log_level: null
            }
          }
        });
        if (res.error) {
          throw res.error;
        }

        // TODO: reset to an empty state?
        setAgentLogLevel(agentPolicyLogLevel);
        setSelectedLogLevel(agentPolicyLogLevel);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.agentLogs.resetLogLevel.successText', {
          defaultMessage: `Reset agent logging level to policy`
        }));
      } catch (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.agentLogs.resetLogLevel.errorTitleText', {
            defaultMessage: 'Error resetting agent logging level'
          })
        });
      }
      setIsResetLevelLoading(false);
    }
    send();
  }, [agent.id, agentPolicyLogLevel, notifications]);
  const onClickApply = (0, _react.useCallback)(() => {
    setIsSetLevelLoading(true);
    async function send() {
      try {
        const res = await (0, _hooks.sendPostAgentAction)(agent.id, {
          action: {
            type: 'SETTINGS',
            data: {
              log_level: selectedLogLevel
            }
          }
        });
        if (res.error) {
          throw res.error;
        }
        setAgentLogLevel(selectedLogLevel);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.agentLogs.selectLogLevel.successText', {
          defaultMessage: `Changed agent logging level to ''{logLevel}''`,
          values: {
            logLevel: selectedLogLevel
          }
        }));
      } catch (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.agentLogs.selectLogLevel.errorTitleText', {
            defaultMessage: 'Error updating agent logging level'
          })
        });
      }
      setIsSetLevelLoading(false);
    }
    send();
  }, [notifications, selectedLogLevel, agent.id]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: "selectAgentLogLevel"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.selectLogLevelLabelText",
    defaultMessage: "Agent logging level"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    disabled: isSetLevelLoading || !authz.fleet.allAgents,
    compressed: true,
    id: "selectAgentLogLevel",
    "data-test-subj": "selectAgentLogLevel",
    value: selectedLogLevel,
    onChange: event => {
      setSelectedLogLevel(event.target.value);
    },
    options: _constants.AGENT_LOG_LEVELS.map(level => ({
      value: level,
      text: level
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    size: "xs",
    disabled: !authz.fleet.allAgents,
    isLoading: isSetLevelLoading || isResetLevelLoading,
    iconType: "check",
    onClick: onClickApply,
    "data-test-subj": "applyLogLevelBtn"
  }, isSetLevelLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.updateButtonLoadingText",
    defaultMessage: "Applying changes..."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.updateButtonText",
    defaultMessage: "Apply changes"
  }))), canResetLogLevel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    size: "xs",
    disabled: !authz.fleet.allAgents,
    isLoading: isSetLevelLoading || isResetLevelLoading,
    iconType: "cross",
    onClick: resetLogLevel,
    "data-test-subj": "resetLogLevelBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.resetLogLevelLabelText",
    defaultMessage: "Reset to policy"
  })))));
});