"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareInputPackagePolicyDataset = prepareInputPackagePolicyDataset;
var _lodash = require("lodash");
var _constants = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function prepareInputPackagePolicyDataset(newPolicy) {
  let forceCreateNeeded = false;
  const {
    inputs
  } = (0, _lodash.cloneDeep)(newPolicy);
  if (!inputs || !inputs.length) {
    return {
      policy: newPolicy,
      forceCreateNeeded: false
    };
  }
  const newInputs = inputs.map(input => {
    const {
      streams
    } = input;
    if (!streams) {
      return input;
    }
    const newStreams = streams.map(stream => {
      var _stream$vars$DATASET_, _datasetVar$value, _newPolicy$package, _datasetVar$value2;
      if (!stream.vars || !stream.vars[_constants.DATASET_VAR_NAME] || !((_stream$vars$DATASET_ = stream.vars[_constants.DATASET_VAR_NAME].value) !== null && _stream$vars$DATASET_ !== void 0 && _stream$vars$DATASET_.package)) {
        return stream;
      }
      const datasetVar = stream.vars[_constants.DATASET_VAR_NAME];
      forceCreateNeeded = ((_datasetVar$value = datasetVar.value) === null || _datasetVar$value === void 0 ? void 0 : _datasetVar$value.package) !== (newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$package = newPolicy.package) === null || _newPolicy$package === void 0 ? void 0 : _newPolicy$package.name);
      stream.vars[_constants.DATASET_VAR_NAME] = {
        ...datasetVar,
        value: (_datasetVar$value2 = datasetVar.value) === null || _datasetVar$value2 === void 0 ? void 0 : _datasetVar$value2.dataset
      };
      return stream;
    });
    return {
      ...input,
      streams: newStreams
    };
  });
  return {
    policy: {
      ...newPolicy,
      inputs: newInputs
    },
    forceCreateNeeded
  };
}