"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyInputConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../services");
var _package_policy_input_var_field = require("./package_policy_input_var_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackagePolicyInputConfig = exports.PackagePolicyInputConfig = /*#__PURE__*/(0, _react.memo)(({
  hasInputStreams,
  packageInputVars,
  packagePolicyInput,
  updatePackagePolicyInput,
  inputVarsValidationResults,
  forceShowErrors,
  isEditPage = false
}) => {
  // Showing advanced options toggle state
  const [isShowingAdvanced, setIsShowingAdvanced] = (0, _react.useState)(false);

  // Errors state
  const hasErrors = forceShowErrors && (0, _services.validationHasErrors)(inputVarsValidationResults);
  const requiredVars = [];
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const advancedVars = [];
  if (packageInputVars) {
    packageInputVars.forEach(varDef => {
      if ((0, _services.isAdvancedVar)(varDef)) {
        advancedVars.push(varDef);
      } else {
        requiredVars.push(varDef);
      }
    });
  }
  const advancedVarsWithErrorsCount = (0, _react.useMemo)(() => advancedVars.filter(({
    name: varName
  }) => {
    var _inputVarsValidationR, _inputVarsValidationR2;
    return (_inputVarsValidationR = inputVarsValidationResults.vars) === null || _inputVarsValidationR === void 0 ? void 0 : (_inputVarsValidationR2 = _inputVarsValidationR[varName]) === null || _inputVarsValidationR2 === void 0 ? void 0 : _inputVarsValidationR2.length;
  }).length, [advancedVars, inputVarsValidationResults.vars]);
  const isBiggerScreen = (0, _eui.useIsWithinMinBreakpoint)('xxl');
  const flexWidth = isBiggerScreen ? 7 : 5;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: flexWidth
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.inputSettingsTitle",
    defaultMessage: "Settings"
  }))), hasInputStreams ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.inputSettingsDescription",
    defaultMessage: "The following settings are applicable to all inputs below."
  })))) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, requiredVars.map(varDef => {
    var _packagePolicyInput$v, _packagePolicyInput$v2, _packagePolicyInput$v3, _packagePolicyInput$v4, _inputVarsValidationR3;
    const {
      name: varName,
      type: varType
    } = varDef;
    const value = (_packagePolicyInput$v = packagePolicyInput.vars) === null || _packagePolicyInput$v === void 0 ? void 0 : (_packagePolicyInput$v2 = _packagePolicyInput$v[varName]) === null || _packagePolicyInput$v2 === void 0 ? void 0 : _packagePolicyInput$v2.value;
    const frozen = (_packagePolicyInput$v3 = packagePolicyInput.vars) === null || _packagePolicyInput$v3 === void 0 ? void 0 : (_packagePolicyInput$v4 = _packagePolicyInput$v3[varName]) === null || _packagePolicyInput$v4 === void 0 ? void 0 : _packagePolicyInput$v4.frozen;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_var_field.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      frozen: frozen,
      onChange: newValue => {
        updatePackagePolicyInput({
          vars: {
            ...packagePolicyInput.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: (_inputVarsValidationR3 = inputVarsValidationResults.vars) === null || _inputVarsValidationR3 === void 0 ? void 0 : _inputVarsValidationR3[varName],
      forceShowErrors: forceShowErrors,
      isEditPage: isEditPage
    }));
  }), advancedVars.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: isShowingAdvanced ? 'arrowDown' : 'arrowRight',
    onClick: () => setIsShowingAdvanced(!isShowingAdvanced),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.toggleAdvancedOptionsButtonText",
    defaultMessage: "Advanced options"
  }))), !isShowingAdvanced && hasErrors && advancedVarsWithErrorsCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",
    defaultMessage: "{count, plural, one {# error} other {# errors}}",
    values: {
      count: advancedVarsWithErrorsCount
    }
  }))) : null)), isShowingAdvanced ? advancedVars.map(varDef => {
    var _packagePolicyInput$v5, _packagePolicyInput$v6, _inputVarsValidationR4;
    const {
      name: varName,
      type: varType
    } = varDef;
    const value = (_packagePolicyInput$v5 = packagePolicyInput.vars) === null || _packagePolicyInput$v5 === void 0 ? void 0 : (_packagePolicyInput$v6 = _packagePolicyInput$v5[varName]) === null || _packagePolicyInput$v6 === void 0 ? void 0 : _packagePolicyInput$v6.value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_var_field.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      onChange: newValue => {
        updatePackagePolicyInput({
          vars: {
            ...packagePolicyInput.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: (_inputVarsValidationR4 = inputVarsValidationResults.vars) === null || _inputVarsValidationR4 === void 0 ? void 0 : _inputVarsValidationR4[varName],
      forceShowErrors: forceShowErrors,
      isEditPage: isEditPage
    }));
  }) : null) : null)));
});