"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPackageReleaseLabel = getPackageReleaseLabel;
exports.isPackagePrerelease = isPackagePrerelease;
exports.mapPackageReleaseToIntegrationCardRelease = mapPackageReleaseToIntegrationCardRelease;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isPackagePrerelease(version) {
  // derive from semver
  return version.startsWith('0') || version.includes('-');
}
function getPackageReleaseLabel(version) {
  if (version.startsWith('0') || version.includes('-preview')) {
    return 'preview';
  } else if (version.includes('-rc')) {
    return 'rc';
  } else if (version.includes('-')) {
    return 'beta';
  }
  return 'ga';
}
function mapPackageReleaseToIntegrationCardRelease(release) {
  return release === 'experimental' ? 'preview' : release;
}