"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsFlyout = void 0;
var _reactQuery = require("@tanstack/react-query");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _chartsTheme = require("@kbn/charts-theme");
var _i18n_texts = require("../i18n_texts");
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DiagnosticsFlyout = ({
  onClose
}) => {
  var _message;
  const {
    filesClient
  } = (0, _context.useFilesManagementContext)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    status,
    refetch,
    data,
    isLoading,
    error
  } = (0, _reactQuery.useQuery)(['filesDiagnostics'], async () => {
    return filesClient.getMetrics();
  });
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'diagnosticsFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "s",
    "aria-labelledby": titleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: titleId
  }, _i18n_texts.i18nTexts.diagnosticsFlyoutTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, status === 'error' ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n_texts.i18nTexts.failedToFetchDiagnostics),
    body: (_message = error === null || error === void 0 ? void 0 : error.message) !== null && _message !== void 0 ? _message : '',
    color: "danger",
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: isLoading,
      color: "danger",
      onClick: () => refetch()
    }, _i18n_texts.i18nTexts.retry)]
  }) : status === 'loading' ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n_texts.i18nTexts.diagnosticsFlyoutSummarySectionTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _numeral.default)(data.storage.esFixedSizeIndex.used).format('0[.]0 b'),
    description: _i18n_texts.i18nTexts.diagnosticsSpaceUsed,
    titleSize: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: Object.values(data.countByStatus).reduce((acc, value) => acc + value, 0),
    description: _i18n_texts.i18nTexts.diagnosticsTotalCount,
    titleSize: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n_texts.i18nTexts.diagnosticsBreakdownsStatus)), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 200,
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y",
    position: _charts.Position.Left,
    showOverlappingTicks: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true
  }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    data: Object.entries(data.countByStatus).map(([key, count]) => ({
      key,
      count
    })),
    id: "Status",
    xAccessor: 'key',
    yAccessors: ['count'],
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    timeZone: "local"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n_texts.i18nTexts.diagnosticsBreakdownsExtension)), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 200,
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y",
    position: _charts.Position.Left,
    showOverlappingTicks: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true
  }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    data: Object.entries(data.countByExtension).map(([key, count]) => ({
      key,
      count
    })),
    id: "Extension",
    xAccessor: 'key',
    yAccessors: ['count'],
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    timeZone: "local"
  }))))));
};
exports.DiagnosticsFlyout = DiagnosticsFlyout;