"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataFieldsRepository = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mapValues = _interopRequireDefault(require("lodash/mapValues"));
var _fields_metadata_dictionary = require("../../../../common/fields_metadata/models/fields_metadata_dictionary");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetadataFieldsRepository {
  constructor(metadataFields) {
    (0, _defineProperty2.default)(this, "metadataFields", void 0);
    this.metadataFields = (0, _mapValues.default)(metadataFields, field => _common.FieldMetadata.create({
      ...field,
      source: 'metadata'
    }));
  }
  getByName(fieldName) {
    return this.metadataFields[fieldName];
  }
  find({
    fieldNames
  } = {}) {
    if (!fieldNames) {
      return _fields_metadata_dictionary.FieldsMetadataDictionary.create(this.metadataFields);
    }
    const fields = fieldNames.reduce((fieldsMetadata, fieldName) => {
      const field = this.getByName(fieldName);
      if (field) {
        fieldsMetadata[fieldName] = field;
      }
      return fieldsMetadata;
    }, {});
    return _fields_metadata_dictionary.FieldsMetadataDictionary.create(fields);
  }
  static create({
    metadataFields
  }) {
    return new MetadataFieldsRepository(metadataFields);
  }
}
exports.MetadataFieldsRepository = MetadataFieldsRepository;