"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsMetadataPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _use_fields_metadata = require("./hooks/use_fields_metadata");
var _fields_metadata = require("./services/fields_metadata");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldsMetadataPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "fieldsMetadata", void 0);
    this.fieldsMetadata = new _fields_metadata.FieldsMetadataService();
  }
  setup() {
    this.fieldsMetadata.setup();
    return {};
  }
  start(core) {
    const {
      http
    } = core;
    const fieldsMetadataService = this.fieldsMetadata.start({
      http
    });
    const useFieldsMetadata = (0, _use_fields_metadata.createUseFieldsMetadataHook)({
      fieldsMetadataService
    });
    return {
      getClient: fieldsMetadataService.getClient,
      useFieldsMetadata
    };
  }
}
exports.FieldsMetadataPlugin = FieldsMetadataPlugin;