"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUseFieldsMetadataHook = void 0;
var _react = require("react");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createUseFieldsMetadataHook = ({
  fieldsMetadataService
}) => {
  return (params = {}, deps) => {
    const [{
      error,
      loading,
      value
    }, load] = (0, _useAsyncFn.default)(async () => {
      const client = await fieldsMetadataService.getClient();
      return client.find(params);
    }, deps);
    (0, _react.useEffect)(() => {
      load();
    }, [load]);
    return {
      fieldsMetadata: value === null || value === void 0 ? void 0 : value.fields,
      loading,
      error,
      reload: load
    };
  };
};
exports.createUseFieldsMetadataHook = createUseFieldsMetadataHook;