"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeaturesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _features_api_client = require("./features_api_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FeaturesPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "apiClient", void 0);
  }
  setup(core) {
    this.apiClient = new _features_api_client.FeaturesAPIClient(core.http);
  }
  start() {
    return {
      getFeatures: () => this.apiClient.getFeatures()
    };
  }
  stop() {}
}
exports.FeaturesPlugin = FeaturesPlugin;