"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionPartitionVisPlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("../common");
var _expression_renderers = require("./expression_renderers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

class ExpressionPartitionVisPlugin {
  setup(core, {
    expressions,
    charts
  }) {
    expressions.registerFunction(_common.partitionLabelsFunction);
    expressions.registerFunction(_common.pieVisFunction);
    expressions.registerFunction(_common.treemapVisFunction);
    expressions.registerFunction(_common.mosaicVisFunction);
    expressions.registerFunction(_common.waffleVisFunction);
    const getStartDeps = (0, _public.createStartServicesGetter)(core.getStartServices);
    expressions.registerRenderer((0, _expression_renderers.getPartitionVisRenderer)({
      getStartDeps
    }));
  }
  start(core, deps) {}
  stop() {}
}
exports.ExpressionPartitionVisPlugin = ExpressionPartitionVisPlugin;