"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEBTTelemetry = void 0;
var _ebtTools = require("@kbn/ebt-tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEBTTelemetry = ({
  analytics,
  queryName
}) => {
  const reportEvent = inspectorAdapters => {
    if (inspectorAdapters) {
      const {
        requests
      } = inspectorAdapters;
      if (requests && analytics) {
        const listReq = requests.getRequests();
        if (listReq.length > 0) {
          // find the highest query time, since a lens chart can contains more than on query, it doesn't make sense to
          // report all of them , only the query with highest latency needs to be reported
          const duration = listReq.reduce((acc, req) => {
            var _req$stats, _req$stats$queryTime$;
            const queryTime = Number((_req$stats = req.stats) === null || _req$stats === void 0 ? void 0 : (_req$stats$queryTime$ = _req$stats.queryTime.value.split('ms')) === null || _req$stats$queryTime$ === void 0 ? void 0 : _req$stats$queryTime$[0]);
            return queryTime > acc ? queryTime : acc;
          }, 0);
          if (duration) {
            (0, _ebtTools.reportPerformanceMetricEvent)(analytics, {
              eventName: 'exploratory_view_query_time',
              duration,
              meta: queryName && {
                queryName
              } || undefined
            });
          }
        }
      }
    }
  };
  return {
    reportEvent
  };
};
exports.useEBTTelemetry = useEBTTelemetry;