"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsDistributionConfig = getSyntheticsDistributionConfig;
var _constants = require("../constants");
var _labels = require("../constants/labels");
var _synthetics = require("../constants/field_names/synthetics");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSyntheticsDistributionConfig({
  series,
  dataView
}) {
  return {
    reportType: _constants.ReportTypes.DISTRIBUTION,
    defaultSeriesType: (series === null || series === void 0 ? void 0 : series.seriesType) || 'line',
    seriesTypes: [],
    xAxisColumn: {
      sourceField: _constants.REPORT_METRIC_FIELD
    },
    yAxisColumns: [{
      sourceField: _constants.RECORDS_PERCENTAGE_FIELD,
      label: _labels.PINGS_LABEL
    }],
    hasOperationType: false,
    filterFields: ['monitor.type', 'observer.geo.name', 'tags', 'url.full'],
    breakdownFields: ['observer.geo.name', 'monitor.name', 'monitor.id', 'monitor.type', 'tags', 'url.port'],
    baseFilters: [],
    definitionFields: [{
      field: 'monitor.name',
      nested: 'synthetics.step.name.keyword',
      singleSelection: true
    }, {
      field: 'url.full',
      filters: (0, _utils.buildExistsFilter)('summary.up', dataView)
    }],
    metricOptions: [{
      label: _labels.MONITORS_DURATION_LABEL,
      id: _synthetics.MONITOR_DURATION_US,
      field: _synthetics.MONITOR_DURATION_US
    }, {
      label: _labels.LCP_LABEL,
      field: _synthetics.SYNTHETICS_LCP,
      id: _synthetics.SYNTHETICS_LCP
    }, {
      label: _labels.FCP_LABEL,
      field: _synthetics.SYNTHETICS_FCP,
      id: _synthetics.SYNTHETICS_FCP
    }, {
      label: _labels.DCL_LABEL,
      field: _synthetics.SYNTHETICS_DCL,
      id: _synthetics.SYNTHETICS_DCL
    }, {
      label: _labels.DOCUMENT_ONLOAD_LABEL,
      field: _synthetics.SYNTHETICS_DOCUMENT_ONLOAD,
      id: _synthetics.SYNTHETICS_DOCUMENT_ONLOAD
    }, {
      label: _labels.CLS_LABEL,
      field: _synthetics.SYNTHETICS_CLS,
      id: _synthetics.SYNTHETICS_CLS
    }],
    labels: {
      ..._constants.FieldLabels,
      'monitor.duration.us': _labels.MONITORS_DURATION_LABEL
    }
  };
}