"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestionUnion = exports.suggestionIntersection = exports.getPosition = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const REGEX = /^(?<type>\w+((?<after_type>\s+((?<mnemonic>(JOIN|JOI|JO|J)((?<after_mnemonic>\s+((?<index>\S+((?<after_index>\s+(?<as>(AS|A))?(?<after_as>\s+(((?<alias>\S+)?(?<after_alias>\s+)?)?))?((?<on>(ON|O)((?<after_on>\s+(?<cond>[^\s])?)?))?))?))?))?))?))?))?/i;
const positions = ['cond', 'after_on', 'on', 'after_alias', 'alias', 'after_as', 'as', 'after_index', 'index', 'after_mnemonic', 'mnemonic', 'after_type', 'type'];

/**
 * Returns the static position, or `cond` if the caret is in the `<conditions>`
 * part of the command, in which case further parsing is needed.
 */
const getStaticPosition = text => {
  const match = text.match(REGEX);
  if (!match || !match.groups) {
    return 'none';
  }
  let pos = 'cond';
  for (const position of positions) {
    if (match.groups[position]) {
      pos = position;
      break;
    }
  }
  return pos;
};
const getPosition = (text, command) => {
  const pos0 = getStaticPosition(text);
  const pos = pos0 === 'cond' ? 'condition' : pos0;
  return {
    pos,
    type: ''
  };
};
exports.getPosition = getPosition;
const suggestionIntersection = (suggestions1, suggestions2) => {
  const labels1 = new Set();
  const intersection = [];
  for (const suggestion1 of suggestions1) {
    labels1.add(suggestion1.label);
  }
  for (const suggestion2 of suggestions2) {
    if (labels1.has(suggestion2.label)) {
      intersection.push({
        ...suggestion2
      });
    }
  }
  return intersection;
};
exports.suggestionIntersection = suggestionIntersection;
const suggestionUnion = (suggestions1, suggestions2) => {
  const labels = new Set();
  const union = [];
  for (const suggestion of suggestions1) {
    const label = suggestion.label;
    if (!labels.has(label)) {
      union.push(suggestion);
      labels.add(label);
    }
  }
  for (const suggestion of suggestions2) {
    const label = suggestion.label;
    if (!labels.has(label)) {
      union.push(suggestion);
      labels.add(label);
    }
  }
  return union;
};
exports.suggestionUnion = suggestionUnion;