"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../shared/helpers");
var _complete_items = require("../../complete_items");
var _factories = require("../../factories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// ToDo: this is hardcoded, we should find a better way to take care of the fork commands
const FORK_AVAILABLE_COMMANDS = ['limit', 'sort', 'where', 'dissect', 'stats', 'eval', 'completion', 'grok', 'change_point', 'mv_expand', 'keep', 'drop', 'rename', 'sample', 'join', 'enrich'];
async function suggest(params) {
  if (/FORK\s+$/i.test(params.innerText)) {
    return [newBranchSuggestion];
  }
  const activeBranch = getActiveBranch(params.command);
  const withinActiveBranch = activeBranch && activeBranch.location.min <= params.innerText.length && activeBranch.location.max >= params.innerText.length;
  if (!withinActiveBranch && /\)\s+$/i.test(params.innerText)) {
    const suggestions = [newBranchSuggestion];
    if (params.command.args.length > 1) {
      suggestions.push(_complete_items.pipeCompleteItem);
    }
    return suggestions;
  }

  // within a branch
  if ((activeBranch === null || activeBranch === void 0 ? void 0 : activeBranch.commands.length) === 0 || (0, _helpers.pipePrecedesCurrentWord)(params.innerText)) {
    return (0, _complete_items.getCommandAutocompleteDefinitions)((0, _helpers.getCommandsByName)(FORK_AVAILABLE_COMMANDS));
  }
  const subCommand = activeBranch === null || activeBranch === void 0 ? void 0 : activeBranch.commands[activeBranch.commands.length - 1];
  if (!subCommand) {
    return [];
  }
  const commandDef = (0, _helpers.getCommandDefinition)(subCommand === null || subCommand === void 0 ? void 0 : subCommand.name);
  return commandDef.suggest({
    ...params,
    command: subCommand,
    definition: commandDef
  });
}
const newBranchSuggestion = {
  kind: 'Issue',
  label: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.suggestions.newBranchLabel', {
    defaultMessage: 'New branch'
  }),
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.suggestions.newBranchDetail', {
    defaultMessage: 'Add a new branch to the fork'
  }),
  text: '($0)',
  asSnippet: true,
  command: _factories.TRIGGER_SUGGESTION_COMMAND
};
const getActiveBranch = command => {
  const finalBranch = command.args[command.args.length - 1];
  if (Array.isArray(finalBranch) || finalBranch.type !== 'query') {
    // should never happen
    return;
  }
  return finalBranch;
};