"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _context = require("../../../shared/context");
var _ = require("../../../..");
var _types = require("../../../definitions/types");
var _factories = require("../../factories");
var _complete_items = require("../../complete_items");
var _helper = require("../../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest(params) {
  let expressionRoot = /,\s*$/.test(params.innerText) ? undefined : params.command.args[params.command.args.length - 1];
  let insideAssignment = false;
  if (expressionRoot && (0, _.isAssignment)(expressionRoot)) {
    // EVAL foo = <use this as the expression root>
    expressionRoot = expressionRoot.args[1][0];
    insideAssignment = true;
    if ((0, _context.isMarkerNode)(expressionRoot)) {
      expressionRoot = undefined;
    }
  }
  const suggestions = await (0, _helper.suggestForExpression)({
    ...params,
    expressionRoot,
    location: _types.Location.EVAL
  });
  const positionInExpression = (0, _helper.getExpressionPosition)(params.innerText, expressionRoot);
  if (positionInExpression === 'empty_expression' && !insideAssignment) {
    suggestions.push((0, _factories.getNewUserDefinedColumnSuggestion)(params.getSuggestedUserDefinedColumnName()));
  }
  if (
  // don't suggest finishing characters if incomplete expression
  (0, _helper.isExpressionComplete)(params.getExpressionType(expressionRoot), params.innerText) &&
  // don't suggest finishing characters if the expression is a column
  // because "EVAL columnName" is a useless expression
  expressionRoot && (!(0, _.isColumnItem)(expressionRoot) || insideAssignment)) {
    suggestions.push(_complete_items.pipeCompleteItem, {
      ..._complete_items.commaCompleteItem,
      text: ', '
    });
  }
  return suggestions;
}