"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entitiesEntityComponentTemplateConfig = void 0;
var _constants_entities = require("../../../common/constants_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entitiesEntityComponentTemplateConfig = exports.entitiesEntityComponentTemplateConfig = {
  name: _constants_entities.ENTITY_ENTITY_COMPONENT_TEMPLATE_V1,
  _meta: {
    description: "Component template for the entity fields used in the Elastic Entity Model's entity discovery framework",
    ecs_version: '8.0.0',
    managed: true
  },
  template: {
    mappings: {
      properties: {
        entity: {
          properties: {
            id: {
              ignore_above: 1024,
              type: 'keyword'
            },
            type: {
              ignore_above: 1024,
              type: 'keyword'
            },
            definition_id: {
              ignore_above: 1024,
              type: 'keyword'
            },
            definition_version: {
              ignore_above: 1024,
              type: 'keyword'
            },
            schema_version: {
              ignore_above: 1024,
              type: 'keyword'
            },
            last_seen_timestamp: {
              type: 'date'
            },
            identity_fields: {
              type: 'keyword'
            }
          }
        }
      }
    }
  }
};