"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteEntityDefinition = deleteEntityDefinition;
var _server = require("@kbn/core/server");
var _saved_objects = require("../../saved_objects");
var _entity_not_found = require("./errors/entity_not_found");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteEntityDefinition(soClient, definition) {
  try {
    await soClient.delete(_saved_objects.SO_ENTITY_DEFINITION_TYPE, definition.id);
  } catch (err) {
    if (_server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
      throw new _entity_not_found.EntityDefinitionNotFound(`Entity definition with [${definition.id}] not found.`);
    }
    throw err;
  }
}